/*!
 * ScrollMagic v2.0.7 (2019-05-07)
 * The javascript library for magical scroll interactions.
 * (c) 2019 Jan Paepke (@janpaepke)
 * Project Website: http://scrollmagic.io
 *
 * @version 2.0.7
 * @license Dual licensed under MIT license and GPL.
 * @author Jan Paepke - e-mail@janpaepke.de
 *
 * @file ScrollMagic main library.
 */(function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.ScrollMagic=t()})(this,function(){"use strict";var e=function(){n.log(2,"(COMPATIBILITY NOTICE) -> As of ScrollMagic 2.0.0 you need to use 'new ScrollMagic.Controller()' to create a new controller instance. Use 'new ScrollMagic.Scene()' to instance a scene.")};e.version="2.0.7",window.addEventListener("mousewheel",function(){});e.Controller=function(o){var r,l,i=t.defaults,a=this,s=n.extend({},i,o),c=[],d=!1,g=0,p="PAUSED",u=!0,m=0,h=!0,f=function(){0<s.refreshInterval&&(l=window.setTimeout(b,s.refreshInterval))},v=function(){return s.vertical?n.get.scrollTop(s.container):n.get.scrollLeft(s.container)},S=function(){return s.vertical?n.get.height(s.container):n.get.width(s.container)},y=this._setScrollPos=function(e){s.vertical?u?window.scrollTo(n.get.scrollLeft(),e):s.container.scrollTop=e:u?window.scrollTo(e,n.get.scrollTop()):s.container.scrollLeft=e},E=function(){if(h&&d){var e=n.type.Array(d)?d:c.slice(0);d=!1;var t=g;g=a.scrollPos();var o=g-t;0!=o&&(p=0<o?"FORWARD":"REVERSE"),"REVERSE"===p&&e.reverse(),e.forEach(function(t,o){N(3,"updating Scene "+(o+1)+"/"+e.length+" ("+c.length+" total)"),t.update(!0)}),0===e.length&&3<=s.loglevel&&N(3,"updating 0 Scenes (nothing added to controller)")}},R=function(){r=n.rAF(E)},w=function(t){N(3,"event fired causing an update:",t.type),"resize"==t.type&&(m=S(),p="PAUSED"),!0!==d&&(d=!0,R())},b=function(){if(!u&&m!=S()){var t;try{t=new Event("resize",{bubbles:!1,cancelable:!1})}catch(o){t=document.createEvent("Event"),t.initEvent("resize",!1,!1)}s.container.dispatchEvent(t)}c.forEach(function(e,t){e.refresh()}),f()},N=this._log=function(e,t){s.loglevel>=e&&(Array.prototype.splice.call(arguments,1,0,"(ScrollMagic.Controller) ->"),n.log.apply(window,arguments))};this._options=s;var T=function(e){if(1>=e.length)return e;var t=e.slice(0);return t.sort(function(e,t){return e.scrollOffset()>t.scrollOffset()?1:-1}),t};return this.addScene=function(t){if(n.type.Array(t))t.forEach(function(e,t){a.addScene(e)});else if(!(t instanceof e.Scene))N(1,"ERROR: invalid argument supplied for '.addScene()'");else if(t.controller()!==a)t.addTo(a);else if(0>c.indexOf(t)){for(var o in c.push(t),c=T(c),t.on("shift.controller_sort",function(){c=T(c)}),s.globalSceneOptions)t[o]&&t[o].call(t,s.globalSceneOptions[o]);N(3,"adding Scene (now "+c.length+" total)")}return a},this.removeScene=function(e){if(n.type.Array(e))e.forEach(function(e,t){a.removeScene(e)});else{var t=c.indexOf(e);-1<t&&(e.off("shift.controller_sort"),c.splice(t,1),N(3,"removing Scene (now "+c.length+" left)"),e.remove())}return a},this.updateScene=function(t,o){return n.type.Array(t)?t.forEach(function(e,t){a.updateScene(e,o)}):o?t.update(!0):!0!==d&&t instanceof e.Scene&&(d=d||[],-1==d.indexOf(t)&&d.push(t),d=T(d),R()),a},this.update=function(e){return w({type:"resize"}),e&&E(),a},this.scrollTo=function(t,o){if(n.type.Number(t))y.call(s.container,t,o);else if(t instanceof e.Scene)t.controller()===a?a.scrollTo(t.scrollOffset(),o):N(2,"scrollTo(): The supplied scene does not belong to this controller. Scroll cancelled.",t);else if(n.type.Function(t))y=t;else{var r=n.get.elements(t)[0];if(r){for(;r.parentNode.hasAttribute("data-scrollmagic-pin-spacer");)r=r.parentNode;var l=s.vertical?"top":"left",i=n.get.offset(s.container),c=n.get.offset(r);u||(i[l]-=a.scrollPos()),a.scrollTo(c[l]-i[l],o)}else N(2,"scrollTo(): The supplied argument is invalid. Scroll cancelled.",t)}return a},this.scrollPos=function(e){return arguments.length?(n.type.Function(e)?v=e:N(2,"Provided value for method 'scrollPos' is not a function. To change the current scroll position use 'scrollTo()'."),a):v.call(a)},this.info=function(e){var t={size:m,vertical:s.vertical,scrollPos:g,scrollDirection:p,container:s.container,isDocument:u};return arguments.length?void 0===t[e]?void N(1,"ERROR: option \""+e+"\" is not available"):t[e]:t},this.loglevel=function(e){return arguments.length?(s.loglevel!=e&&(s.loglevel=e),a):s.loglevel},this.enabled=function(e){return arguments.length?(h!=e&&(h=!!e,a.updateScene(c,!0)),a):h},this.destroy=function(e){window.clearTimeout(l);for(var t=c.length;t--;)c[t].destroy(e);return s.container.removeEventListener("resize",w),s.container.removeEventListener("scroll",w),n.cAF(r),N(3,"destroyed ScrollMagic.Controller (reset: "+(e?"true":"false")+")"),null},function(){for(var t in s)i.hasOwnProperty(t)||(N(2,"WARNING: Unknown option \""+t+"\""),delete s[t]);if(s.container=n.get.elements(s.container)[0],!s.container)throw N(1,"ERROR creating object ScrollMagic.Controller: No valid scroll container supplied"),"ScrollMagic.Controller init failed.";u=s.container===window||s.container===document.body||!document.body.contains(s.container),u&&(s.container=window),m=S(),s.container.addEventListener("resize",w),s.container.addEventListener("scroll",w);var o=parseInt(s.refreshInterval,10);s.refreshInterval=n.type.Number(o)?o:i.refreshInterval,f(),N(3,"added new ScrollMagic.Controller controller (v"+e.version+")")}(),a};var t={defaults:{container:window,vertical:!0,globalSceneOptions:{},loglevel:2,refreshInterval:100}};e.Controller.addOption=function(e,o){t.defaults[e]=o},e.Controller.extend=function(t){var o=this;e.Controller=function(){return o.apply(this,arguments),this.$super=n.extend({},this),t.apply(this,arguments)||this},n.extend(e.Controller,o),e.Controller.prototype=o.prototype,e.Controller.prototype.constructor=e.Controller},e.Scene=function(t){var r,l,i="ScrollMagic.Scene",a="BEFORE",s="DURING",c="AFTER",d=o.defaults,g=this,p=n.extend({},d,t),u="BEFORE",m=0,h={start:0,end:0},f=0,v=!0,S=function(){for(var e in p)d.hasOwnProperty(e)||(E(2,"WARNING: Unknown option \""+e+"\""),delete p[e]);for(var t in d)F(t);O()},y={};this.on=function(e,t){return n.type.Function(t)?(e=e.trim().split(" "),e.forEach(function(e){var o=e.split("."),n=o[0],r=o[1];"*"!=n&&(!y[n]&&(y[n]=[]),y[n].push({namespace:r||"",callback:t}))})):E(1,"ERROR when calling '.on()': Supplied callback for '"+e+"' is not a valid function!"),g},this.off=function(e,t){return e?(e=e.trim().split(" "),e.forEach(function(e,o){var n=e.split("."),r=n[0],l=n[1]||"",i="*"===r?Object.keys(y):[r];i.forEach(function(e){for(var o,n=y[e]||[],r=n.length;r--;)o=n[r],o&&(l===o.namespace||"*"===l)&&(!t||t==o.callback)&&n.splice(r,1);n.length||delete y[e]})}),g):(E(1,"ERROR: Invalid event name supplied."),g)},this.trigger=function(t,o){if(t){var n=t.trim().split("."),r=n[0],l=n[1],i=y[r];E(3,"event fired:",r,o?"->":"",o||""),i&&i.forEach(function(t,n){l&&l!==t.namespace||t.callback.call(g,new e.Event(r,t.namespace,g,o))})}else E(1,"ERROR: Invalid event name supplied.");return g},g.on("change.internal",function(t){"loglevel"!==t.what&&"tweenChanges"!==t.what&&("triggerElement"===t.what?b():"reverse"===t.what&&g.update())}).on("shift.internal",function(t){R(),g.update()});var E=this._log=function(e,t){p.loglevel>=e&&(Array.prototype.splice.call(arguments,1,0,"(ScrollMagic.Scene) ->"),n.log.apply(window,arguments))};this.addTo=function(t){return t instanceof e.Controller?l!=t&&(l&&l.removeScene(g),l=t,O(),w(!0),b(!0),R(),l.info("container").addEventListener("resize",N),t.addScene(g),g.trigger("add",{controller:l}),E(3,"added ScrollMagic.Scene to controller"),g.update()):E(1,"ERROR: supplied argument of 'addTo()' is not a valid ScrollMagic Controller"),g},this.enabled=function(e){return arguments.length?(v!=e&&(v=!!e,g.update(!0)),g):v},this.remove=function(){if(l){l.info("container").removeEventListener("resize",N);var e=l;l=void 0,e.removeScene(g),g.trigger("remove"),E(3,"removed ScrollMagic.Scene from controller")}return g},this.destroy=function(e){return g.trigger("destroy",{reset:e}),g.remove(),g.off("*.*"),E(3,"destroyed ScrollMagic.Scene (reset: "+(e?"true":"false")+")"),null},this.update=function(e){if(l)if(!e)l.updateScene(g,!1);else if(l.enabled()&&v){var t,o=l.info("scrollPos");t=0<p.duration?(o-h.start)/(h.end-h.start):o>=h.start?1:0,g.trigger("update",{startPos:h.start,endPos:h.end,scrollPos:o}),g.progress(t)}else I&&"DURING"===u&&P(!0);return g},this.refresh=function(){return w(),b(),g},this.progress=function(e){if(!arguments.length)return m;var t=!1,o=u,n=l?l.info("scrollDirection"):"PAUSED",r=p.reverse||e>=m;if(0===p.duration?(t=m!=e,m=1>e&&r?0:1,u=0===m?"BEFORE":"DURING"):0>e&&"BEFORE"!==u&&r?(m=0,u="BEFORE",t=!0):0<=e&&1>e&&r?(m=e,u="DURING",t=!0):1<=e&&"AFTER"!==u?(m=1,u="AFTER",t=!0):"DURING"===u&&!r&&P(),t){var i={progress:m,state:u,scrollDirection:n},a=u!=o,s=function(e){g.trigger(e,i)};a&&"DURING"!==o&&(s("enter"),s("BEFORE"===o?"start":"end")),s("progress"),a&&"DURING"!==u&&(s("BEFORE"===u?"start":"end"),s("leave"))}return g};var R=function(){h={start:f+p.offset},l&&p.triggerElement&&(h.start-=l.info("size")*p.triggerHook),h.end=h.start+p.duration},w=function(e){if(r){var t="duration";C("duration",r.call(g))&&!e&&(g.trigger("change",{what:"duration",newval:p.duration}),g.trigger("shift",{reason:"duration"}))}},b=function(e){var t=0,o=p.triggerElement;if(l&&(o||0<f)){if(o)if(o.parentNode){for(var r=l.info(),i=n.get.offset(r.container),a=r.vertical?"top":"left";o.parentNode.hasAttribute("data-scrollmagic-pin-spacer");)o=o.parentNode;var s=n.get.offset(o);r.isDocument||(i[a]-=l.scrollPos()),t=s[a]-i[a]}else E(2,"WARNING: triggerElement was removed from DOM and will be reset to",void 0),g.triggerElement(void 0);var c=t!=f;f=t,c&&!e&&g.trigger("shift",{reason:"triggerElementPosition"})}},N=function(t){0<p.triggerHook&&g.trigger("shift",{reason:"containerResize"})},T=n.extend(o.validate,{duration:function(t){if(n.type.String(t)&&t.match(/^(\.|\d)*\d+%$/)){var o=parseFloat(t)/100;t=function(){return l?l.info("size")*o:0}}if(n.type.Function(t)){r=t;try{t=parseFloat(r.call(g))}catch(o){t=-1}}if(t=parseFloat(t),!n.type.Number(t)||0>t)if(r)throw r=void 0,["Invalid return value of supplied function for option \"duration\":",t];else throw["Invalid value for option \"duration\":",t];return t}}),O=function(e){e=arguments.length?[e]:Object.keys(T),e.forEach(function(t,o){var r;if(T[t])try{r=T[t](p[t])}catch(o){r=d[t];var l=n.type.String(o)?[o]:o;n.type.Array(l)?(l[0]="ERROR: "+l[0],l.unshift(1),E.apply(this,l)):E(1,"ERROR: Problem executing validation callback for option '"+t+"':",o.message)}finally{p[t]=r}})},C=function(e,t){var o=!1,n=p[e];return p[e]!=t&&(p[e]=t,O(e),o=n!=p[e]),o},F=function(e){g[e]||(g[e]=function(t){return arguments.length?("duration"===e&&(r=void 0),C(e,t)&&(g.trigger("change",{what:e,newval:p[e]}),-1<o.shifts.indexOf(e)&&g.trigger("shift",{reason:e})),g):p[e]})};this.controller=function(){return l},this.state=function(){return u},this.scrollOffset=function(){return h.start},this.triggerPosition=function(){var e=p.offset;return l&&(p.triggerElement?e+=f:e+=l.info("size")*g.triggerHook()),e};var I,x;g.on("shift.internal",function(t){var e="duration"===t.reason;("AFTER"===u&&e||"DURING"===u&&0===p.duration)&&P(),e&&A()}).on("progress.internal",function(t){P()}).on("add.internal",function(t){A()}).on("destroy.internal",function(t){g.removePin(t.reset)});var P=function(e){if(I&&l){var t=l.info(),o=x.spacer.firstChild;if(!e&&"DURING"===u){"fixed"!=n.css(o,"position")&&(n.css(o,{position:"fixed"}),A());var r=n.get.offset(x.spacer,!0),i=p.reverse||0===p.duration?t.scrollPos-h.start:Math.round(10*(m*p.duration))/10;r[t.vertical?"top":"left"]+=i,n.css(x.spacer.firstChild,{top:r.top,left:r.left})}else{var a={position:x.inFlow?"relative":"absolute",top:0,left:0},s=n.css(o,"position")!=a.position;x.pushFollowers?0<p.duration&&("AFTER"===u&&0===parseFloat(n.css(x.spacer,"padding-top"))?s=!0:"BEFORE"===u&&0===parseFloat(n.css(x.spacer,"padding-bottom"))&&(s=!0)):a[t.vertical?"top":"left"]=p.duration*m,n.css(o,a),s&&A()}}},A=function(){if(I&&l&&x.inFlow){var e="AFTER"===u,t="BEFORE"===u,o="DURING"===u,r=l.info("vertical"),i=x.spacer.firstChild,a=n.isMarginCollapseType(n.css(x.spacer,"display")),s={};x.relSize.width||x.relSize.autoFullWidth?o?n.css(I,{width:n.get.width(x.spacer)}):n.css(I,{width:"100%"}):(s["min-width"]=n.get.width(r?I:i,!0,!0),s.width=o?s["min-width"]:"auto"),x.relSize.height?o?n.css(I,{height:n.get.height(x.spacer)-(x.pushFollowers?p.duration:0)}):n.css(I,{height:"100%"}):(s["min-height"]=n.get.height(r?i:I,!0,!a),s.height=o?s["min-height"]:"auto"),x.pushFollowers&&(s["padding"+(r?"Top":"Left")]=p.duration*m,s["padding"+(r?"Bottom":"Right")]=p.duration*(1-m)),n.css(x.spacer,s)}},z=function(){l&&I&&"DURING"===u&&!l.info("isDocument")&&P()},k=function(){l&&I&&"DURING"===u&&((x.relSize.width||x.relSize.autoFullWidth)&&n.get.width(window)!=n.get.width(x.spacer.parentNode)||x.relSize.height&&n.get.height(window)!=n.get.height(x.spacer.parentNode))&&A()},D=function(t){l&&I&&"DURING"===u&&!l.info("isDocument")&&(t.preventDefault(),l._setScrollPos(l.info("scrollPos")-((t.wheelDelta||t[l.info("vertical")?"wheelDeltaY":"wheelDeltaX"])/3||30*-t.detail)))};this.setPin=function(e,t){var o={pushFollowers:!0,spacerClass:"scrollmagic-pin-spacer"},r=t&&t.hasOwnProperty("pushFollowers");if(t=n.extend({},o,t),e=n.get.elements(e)[0],!e)return E(1,"ERROR calling method 'setPin()': Invalid pin element supplied."),g;if("fixed"===n.css(e,"position"))return E(1,"ERROR calling method 'setPin()': Pin does not work with elements that are positioned 'fixed'."),g;if(I){if(I===e)return g;g.removePin()}I=e;var l=I.parentNode.style.display,i=["top","left","bottom","right","margin","marginLeft","marginRight","marginTop","marginBottom"];I.parentNode.style.display="none";var a="absolute"!=n.css(I,"position"),s=n.css(I,i.concat(["display"])),c=n.css(I,["width","height"]);I.parentNode.style.display=l,!a&&t.pushFollowers&&(E(2,"WARNING: If the pinned element is positioned absolutely pushFollowers will be disabled."),t.pushFollowers=!1),window.setTimeout(function(){I&&0===p.duration&&r&&t.pushFollowers&&E(2,"WARNING: pushFollowers =",!0,"has no effect, when scene duration is 0.")},0);var d=I.parentNode.insertBefore(document.createElement("div"),I),u=n.extend(s,{position:a?"relative":"absolute",boxSizing:"content-box",mozBoxSizing:"content-box",webkitBoxSizing:"content-box"});if(a||n.extend(u,n.css(I,["width","height"])),n.css(d,u),d.setAttribute("data-scrollmagic-pin-spacer",""),n.addClass(d,t.spacerClass),x={spacer:d,relSize:{width:"%"===c.width.slice(-1),height:"%"===c.height.slice(-1),autoFullWidth:"auto"===c.width&&a&&n.isMarginCollapseType(s.display)},pushFollowers:t.pushFollowers,inFlow:a},!I.___origStyle){I.___origStyle={};var m=I.style,h=i.concat(["width","height","position","boxSizing","mozBoxSizing","webkitBoxSizing"]);h.forEach(function(e){I.___origStyle[e]=m[e]||""})}return x.relSize.width&&n.css(d,{width:c.width}),x.relSize.height&&n.css(d,{height:c.height}),d.appendChild(I),n.css(I,{position:a?"relative":"absolute",margin:"auto",top:"auto",left:"auto",bottom:"auto",right:"auto"}),(x.relSize.width||x.relSize.autoFullWidth)&&n.css(I,{boxSizing:"border-box",mozBoxSizing:"border-box",webkitBoxSizing:"border-box"}),window.addEventListener("scroll",z),window.addEventListener("resize",z),window.addEventListener("resize",k),I.addEventListener("mousewheel",D),I.addEventListener("DOMMouseScroll",D),E(3,"added pin"),P(),g},this.removePin=function(e){if(I){if("DURING"===u&&P(!0),e||!l){var t=x.spacer.firstChild;if(t.hasAttribute("data-scrollmagic-pin-spacer")){var o=x.spacer.style,r=["margin","marginLeft","marginRight","marginTop","marginBottom"],i={};r.forEach(function(e){i[e]=o[e]||""}),n.css(t,i)}x.spacer.parentNode.insertBefore(t,x.spacer),x.spacer.parentNode.removeChild(x.spacer),I.parentNode.hasAttribute("data-scrollmagic-pin-spacer")||(n.css(I,I.___origStyle),delete I.___origStyle)}window.removeEventListener("scroll",z),window.removeEventListener("resize",z),window.removeEventListener("resize",k),I.removeEventListener("mousewheel",D),I.removeEventListener("DOMMouseScroll",D),I=void 0,E(3,"removed pin (reset: "+(e?"true":"false")+")")}return g};var L,_=[];return g.on("destroy.internal",function(t){g.removeClassToggle(t.reset)}),this.setClassToggle=function(e,t){var o=n.get.elements(e);return 0!==o.length&&n.type.String(t)?(0<_.length&&g.removeClassToggle(),L=t,_=o,g.on("enter.internal_class leave.internal_class",function(t){var e="enter"===t.type?n.addClass:n.removeClass;_.forEach(function(t,o){e(t,L)})}),g):(E(1,"ERROR calling method 'setClassToggle()': Invalid "+(0===o.length?"element":"classes")+" supplied."),g)},this.removeClassToggle=function(e){return e&&_.forEach(function(e,t){n.removeClass(e,L)}),g.off("start.internal_class end.internal_class"),L=void 0,_=[],g},S(),g};var o={defaults:{duration:0,offset:0,triggerElement:void 0,triggerHook:.5,reverse:!0,loglevel:2},validate:{offset:function(e){if(e=parseFloat(e),!n.type.Number(e))throw["Invalid value for option \"offset\":",e];return e},triggerElement:function(e){if(e=e||void 0,e){var t=n.get.elements(e)[0];if(t&&t.parentNode)e=t;else throw["Element defined in option \"triggerElement\" was not found:",e]}return e},triggerHook:function(e){var t={onCenter:.5,onEnter:1,onLeave:0};if(n.type.Number(e))e=Math.max(0,Math.min(parseFloat(e),1));else if(e in t)e=t[e];else throw["Invalid value for option \"triggerHook\": ",e];return e},reverse:function(e){return!!e},loglevel:function(e){if(e=parseInt(e),!n.type.Number(e)||0>e||3<e)throw["Invalid value for option \"loglevel\":",e];return e}},shifts:["duration","offset","triggerHook"]};e.Scene.addOption=function(t,n,r,l){t in o.defaults?e._util.log(1,"[static] ScrollMagic.Scene -> Cannot add Scene option '"+t+"', because it already exists."):(o.defaults[t]=n,o.validate[t]=r,l&&o.shifts.push(t))},e.Scene.extend=function(t){var o=this;e.Scene=function(){return o.apply(this,arguments),this.$super=n.extend({},this),t.apply(this,arguments)||this},n.extend(e.Scene,o),e.Scene.prototype=o.prototype,e.Scene.prototype.constructor=e.Scene},e.Event=function(e,t,o,n){for(var r in n=n||{},n)this[r]=n[r];return this.type=e,this.target=this.currentTarget=o,this.namespace=t||"",this.timeStamp=this.timestamp=Date.now(),this};var n=e._util=function(e){var t,o={},n=function(e){return parseFloat(e)||0},r=function(t){return t.currentStyle?t.currentStyle:e.getComputedStyle(t)},l=function(t,o,l,i){if(o=o===document?e:o,o===e)i=!1;else if(!h.DomElement(o))return 0;t=t.charAt(0).toUpperCase()+t.substr(1).toLowerCase();var a=(l?o["offset"+t]||o["outer"+t]:o["client"+t]||o["inner"+t])||0;if(l&&i){var s=r(o);a+="Height"===t?n(s.marginTop)+n(s.marginBottom):n(s.marginLeft)+n(s.marginRight)}return a},a=function(e){return e.replace(/^[^a-z]+([a-z])/g,"$1").replace(/-([a-z])/g,function(e){return e[1].toUpperCase()})};o.extend=function(e){for(e=e||{},t=1;t<arguments.length;t++)if(arguments[t])for(var o in arguments[t])arguments[t].hasOwnProperty(o)&&(e[o]=arguments[t][o]);return e},o.isMarginCollapseType=function(e){return-1<["block","flex","list-item","table","-webkit-box"].indexOf(e)};var s=0,c=["ms","moz","webkit","o"],d=e.requestAnimationFrame,g=e.cancelAnimationFrame;for(t=0;!d&&t<c.length;++t)d=e[c[t]+"RequestAnimationFrame"],g=e[c[t]+"CancelAnimationFrame"]||e[c[t]+"CancelRequestAnimationFrame"];d||(d=function(t){var o=new Date().getTime(),n=Math.max(0,16-(o-s)),r=e.setTimeout(function(){t(o+n)},n);return s=o+n,r}),g||(g=function(t){e.clearTimeout(t)}),o.rAF=d.bind(e),o.cAF=g.bind(e);var p=["error","warn","log"],u=e.console||{};for(u.log=u.log||function(){},t=0;t<p.length;t++){var m=p[t];u[m]||(u[m]=u.log)}o.log=function(e){(e>p.length||0>=e)&&(e=p.length);var t=new Date,o=("0"+t.getHours()).slice(-2)+":"+("0"+t.getMinutes()).slice(-2)+":"+("0"+t.getSeconds()).slice(-2)+":"+("00"+t.getMilliseconds()).slice(-3),n=p[e-1],r=Array.prototype.splice.call(arguments,1),l=Function.prototype.bind.call(u[n],u);r.unshift(o),l.apply(u,r)};var h=o.type=function(e){return Object.prototype.toString.call(e).replace(/^\[object (.+)\]$/,"$1").toLowerCase()};h.String=function(e){return"string"===h(e)},h.Function=function(e){return"function"===h(e)},h.Array=function(e){return Array.isArray(e)},h.Number=function(e){return!h.Array(e)&&0<=e-parseFloat(e)+1},h.DomElement=function(e){return"object"==typeof HTMLElement||"function"==typeof HTMLElement?e instanceof HTMLElement||e instanceof SVGElement:e&&"object"==typeof e&&null!==e&&1===e.nodeType&&"string"==typeof e.nodeName};var f=o.get={};return f.elements=function(t){var o=[];if(h.String(t))try{t=document.querySelectorAll(t)}catch(t){return o}if("nodelist"===h(t)||h.Array(t)||t instanceof NodeList)for(var n,r=0,l=o.length=t.length;r<l;r++)n=t[r],o[r]=h.DomElement(n)?n:f.elements(n);else(h.DomElement(t)||t===document||t===e)&&(o=[t]);return o},f.scrollTop=function(t){return t&&"number"==typeof t.scrollTop?t.scrollTop:e.pageYOffset||0},f.scrollLeft=function(t){return t&&"number"==typeof t.scrollLeft?t.scrollLeft:e.pageXOffset||0},f.width=function(e,t,o){return l("width",e,t,o)},f.height=function(e,t,o){return l("height",e,t,o)},f.offset=function(e,t){var o={top:0,left:0};if(e&&e.getBoundingClientRect){var n=e.getBoundingClientRect();o.top=n.top,o.left=n.left,t||(o.top+=f.scrollTop(),o.left+=f.scrollLeft())}return o},o.addClass=function(e,t){t&&(e.classList?e.classList.add(t):e.className+=" "+t)},o.removeClass=function(e,t){t&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\b)"+t.split(" ").join("|")+"(\\b|$)","gi")," "))},o.css=function(e,t){if(h.String(t))return r(e)[a(t)];if(h.Array(t)){var o={},n=r(e);return t.forEach(function(e,t){o[e]=n[a(e)]}),o}for(var l in t){var i=t[l];i==parseFloat(i)&&(i+="px"),e.style[a(l)]=i}},o}(window||{});return e.Scene.prototype.addIndicators=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling addIndicators() due to missing Plugin 'debug.addIndicators'. Please make sure to include plugins/debug.addIndicators.js"),this},e.Scene.prototype.removeIndicators=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeIndicators() due to missing Plugin 'debug.addIndicators'. Please make sure to include plugins/debug.addIndicators.js"),this},e.Scene.prototype.setTween=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling setTween() due to missing Plugin 'animation.gsap'. Please make sure to include plugins/animation.gsap.js"),this},e.Scene.prototype.removeTween=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeTween() due to missing Plugin 'animation.gsap'. Please make sure to include plugins/animation.gsap.js"),this},e.Scene.prototype.setVelocity=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling setVelocity() due to missing Plugin 'animation.velocity'. Please make sure to include plugins/animation.velocity.js"),this},e.Scene.prototype.removeVelocity=function(){return e._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeVelocity() due to missing Plugin 'animation.velocity'. Please make sure to include plugins/animation.velocity.js"),this},e});